# apt-get install python3-lgpio

from gpiozero import Button, LED
from signal import pause
import os
import time

# BCM Numbering
BUTTON_PIN = 9
LED_PIN = 11

# Initialize hardware
btn = Button(BUTTON_PIN, hold_time=4.0)
led = LED(LED_PIN)

# Variable to track the exact moment the button was pressed
button_press_start = 0

def start_heartbeat():
    """Blinks the LED for 0.1s every 10 seconds"""
    # background=True is default, this runs in a separate thread
    led.blink(on_time=0.1, off_time=9.9, n=None)

def handle_press():
    global button_press_start
    # led.off() stops any active blink/background thread immediately
    led.off()
    button_press_start = time.time()
    # Turn LED on solid to indicate the button is being held
    led.on()

def handle_hold():
    """Triggered strictly at the 4-second mark"""
    print("Threshold reached: Shutting down...")
    # Rapid flashing to confirm shutdown sequence
    led.blink(on_time=0.1, off_time=0.1, n=10)
    os.system("sudo /usr/sbin/shutdown -h now")

def handle_release():
    """Triggered on any release"""
    global button_press_start
    led.off()

    if button_press_start == 0:
        start_heartbeat()
        return

    duration = time.time() - button_press_start
    button_press_start = 0

    #print(f"Button released after {duration:.2f} seconds")

    if 0.5 < duration < 4.0:
        print("Rebooting...")
        led.on()
        time.sleep(1)
        os.system("sudo /usr/sbin/reboot")
    else:
        # If it was a short press or after a reboot command failed
        # we resume the heartbeat
        start_heartbeat()

print("Shutdown monitor active...")
start_heartbeat()

# Assign functions to events
btn.when_pressed = handle_press
btn.when_held = handle_hold
btn.when_released = handle_release

pause()
