# apt-get install gpiod python3-libgpiod

import gpiod
import time
import os

# Mapping for Pi 1 B+
# Physical 21 is BCM 9
# Physical 23 is BCM 11
BUTTON_PIN = 9
LED_PIN = 11

# Identify the GPIO chip (usually 0 on Pi 1/2/3/4)
CHIP_ID = "gpiochip0"

def run_monitor():
    try:
        chip = gpiod.Chip(CHIP_ID)

        # Setup LED as output
        led_line = chip.get_line(LED_PIN)
        led_line.request(consumer="ShutdownScript", type=gpiod.LINE_REQ_DIR_OUT)

        # Setup Button as input
        btn_line = chip.get_line(BUTTON_PIN)
        btn_line.request(consumer="ShutdownScript", type=gpiod.LINE_REQ_DIR_IN,
                         flags=gpiod.LINE_REQ_FLAG_BIAS_PULL_UP)

        print("Shutdownmonitor active...")

        # Initial LED blink
        led_line.set_value(1)
        time.sleep(1)
        led_line.set_value(0)

        heartbeat_counter = 0

        while True:

            # Check button (0 is pressed because of PULL_UP)
            if btn_line.get_value() == 0:

                #print("button pressed")

                start_time = time.time()
                led_line.set_value(1) # Turn LED on while holding

                # Wait for release and count duration
                while btn_line.get_value() == 0:
                    time.sleep(0.1)
                    duration = time.time() - start_time

                    # exit out of here if button is pressed long
                    if duration > 4.0:
                        break

                #print("button released, duration: ", duration)

                led_line.set_value(0)

                if duration > 4.0:
                    print("Shutting down...")
                    os.system("/usr/sbin/shutdown -h now")
                    break
                elif duration > 0.5:
                    print("Rebooting...")
                    os.system("/usr/sbin/reboot")
                    break

            # Simple heartbeat blink every 10 seconds
            if (heartbeat_counter > 100):
                led_line.set_value(1)
                time.sleep(0.1)
                led_line.set_value(0)

                heartbeat_counter = 0

            heartbeat_counter = heartbeat_counter + 1
            time.sleep(0.1)


    except Exception as e:
        print(f"Error: {e}")
    finally:
        # Proper cleanup
        led_line.release()
        btn_line.release()

if __name__ == "__main__":
    run_monitor()
